/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.servlet.util.ETagManager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.catalina.util.FastHttpDateFormat;

public class CssCacheFilter
implements Filter {
    public static final String TRACE_MASKT = "SFILCSST";
    public static final String TRACE_MASKF = "SFILCSSF";

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ETagManager.getETagManager().handleRequest(request, response)) {
            if (request instanceof HttpServletRequest) {
                final HttpServletRequest theRequest = (HttpServletRequest)request;
                chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)response){

                    public void setContentType(String type) {
                        super.setContentType(type);
                        if ("text/css".equals(type)) {
                            Trace.trace(CssCacheFilter.TRACE_MASKT, "CssCacheFilter detects text/css, applying ETag and Expires.");
                            this.addHeader("ETag", ETagManager.getETagManager().createETag(theRequest.getRequestURI()));
                            this.addHeader("Expires", FastHttpDateFormat.getDate((Date)new Date(System.currentTimeMillis() + 3600000L)));
                        }
                    }
                });
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public void destroy() {
    }
}

